# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


proc x_0 {} {
    return "[and [diamond P] [diamond [not P]]]" 
}

proc x_1 {} {
    return "[and [box [imp P [weaknext P]]] [and P [diamond [not P]]]]" 
}

proc x_2 {} {
    return "[and [diamond [box P]] [diamond [box [not P]]]]" 
}

proc x_3 {} {
    return "[box [more]]" 
}

proc x_4 {} {
    return "P and [gets_r P [not P]] and [fin_r Q] and [box_m [equiv Q [not [next Q]]]] and [len_r 3]"
}

proc x_5 {} {
    return "<(chopstar[skip_e]);[skip_e]>[empty_r] and [len_r 6]"
}

proc x_6 {} {
    return "<chopstar (test P;[skip_e])>[empty] and <chopstar([skip_e];test(not P))>[empty]" 
}

proc x_7 {} {
    return "[fin_r P] and <chopstar([skip_e];test(not P))>[empty]" 
}

proc x_8 {} {
    return "(P until (not P)) and [box_m P] and [len_r 5]" 
}

proc x_9 {} {
    return "(P until [and [box [not P]] [len_gt_r 3]]) and (P) and (next P) and ([len_ge_r 9])"
}

proc x_10 {} {
    set tt "step(not(Q equiv (next Q)))" 
    return "([len_eq_r 5] and [while_r [not P] $tt])"
}

proc x_11 {} {
    return "[equiv [box_m P] [not [diamond_m [not P]]]]"
}

proc x_12 {} {
    set tt1 "(P imp (next Q))"
    set tt2 "([diamond P])"
    set tt3 "([diamond [not P]])"
    set tt4 "([diamond Q])"
    set tt5 "([diamond [not Q]])"
    set tt "($tt1 and $tt2 and $tt3 and $tt4 and $tt5)"
    return "[box $tt]"
}


proc x_13 {} {
    set n 4
    set tt1 "([diamond [and P [di_e_r [stable_eq_e $n P]]]])"
    #puts "$tt1" 
    set tt2 "([diamond [and [not P] [di_e_r [stable_eq_e $n P]]]])"
    #puts "$tt2"
    set tt "($tt1 and $tt2)"
    return "[box $tt]"
}

proc x_14 {} {
    set tt "[imp P [next P]]"
    return "[imp [and P [box_m $tt]] [box P]]"
}
    
