# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD BDD and BuDDy packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

#############################################################################
# 
# policy library
#
#############################################################################

proc r_always_followed_by  { a b } {
    return "(not(<($a)>(not( $b ))))"
}

proc r_afb  { a b } {
    return "(not(<($a)>(not( $b ))))"
}

proc l_always_followed_by { a b } {
    return "(not( ($a) <test(not ($b))>))"
}

proc l_afb { a b } {
    return "(not( ($a) <test(not ($b))>))"
}

proc r_strong_followed_by_0 { a b } {
#remember to put always_r at outer level
    #insert "RULE: $a   strong_followed_by_0   $b"
    return "[equiv $a $b]"  
}

proc r_sfb_0 { a b } {
#remember to put always_r at outer level
    #insert "RULE: $a   strong_followed_by_0   $b"
    return "[equiv $a $b]"  
}

proc l_strong_followed_by_0 { a b } {
#remember to put always_l at outer level
    #insert "RULE: $a   strong_followed_by_0   $b"
    return "[equiv $a $b]"  
}

proc l_sfb_0 { a b } {
#remember to put always_l at outer level
    #insert "RULE: $a   strong_followed_by_0   $b"
    return "[equiv $a $b]"  
}

proc r_always_followed_by_true  { b } {
    return "(not(<[true_e]>(not( $b ))))"
}

proc r_afb_true  { b } {
    return "(not(<[true_e]>(not( $b ))))"
}

proc l_always_followed_by_true  { b } {
    return "(not(true <test(not( $b ))>))"
}

proc l_afb_true  { b } {
    return "(not(true <test(not( $b ))>))"
}

proc r_strong_always_followed_by_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "[always_r $b]"
}

proc r_safb_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "[always_r $b]"
}

proc l_strong_always_followed_by_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "[always_l $b]"
}

proc l_safb_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "[always_l $b]"
}

proc r_strong_followed_by_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "$b"
}

proc r_sfb_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "$b"
}

proc l_strong_always_followed_by_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "$b"
}

proc l_sfb_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
    return "$b"
}

#####################################################

#proc p_rule_1  { a b } {
#    return "not{<{$a}>{not{ $b }}}"
#}

#proc p_p_rule_1 { a b } {
#    return "not{ $a <test{not $b};[finite_e]>}"
#}

#proc p_rule_1_true  { b } {
#    return "not{<[finite_e]>{not{ $b }}}"
#}

#proc strong_p_rule_1_true  { b } {
#    puts " true  strong_p_rule_1_true $b"
#    return "[always $b]"
#}

#proc p_rule_2 { a b } {
#    return "not{< $a > {not{ $b }}}" 
#}

#proc p_rule_s_1 { a b } {
#    return "not{<[finite_e];test{$a};[finite_e]>{not{ $b }}}"  
#} 



#proc p_rule_s_2 { a b } {
#    return "not{<test{$a};[finite_e]>{not{ $b }}}"   
#}


#proc p_rule_s_1_k { k a b } {
#    return "not{<[finite_e];test{$a};[len_e $k]>{not{ $b }}}"  
#} 

#proc strong_p_rule_s_1_0 { a b } {
#remember to put always at outer level
#    insert "RULE: $a   strong_p_rule_0   $b"
#    return "[equiv $a $b]"  
#}

#proc p_rule_s_2_k { k a b } {
#    return "not {< test { $a }; [len_e $k]> { not { $b } } }"   
#}

#proc sprule3 { a b } {
#    return "<[finite_e]> { [and [empty] [equiv $a   $b]] }"  
#}

