# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD BDD and BuDDy packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# System routines 
###########################################
proc STor { a b } {
    return "{stor $a $b}"
}

proc STand { a b } {
    return "{stand $a $b}"
}

proc STequiv { a b } {
    return "{stequiv $a $b}"
}

proc STimp { a b } {
    return "{stimp $a $b}"
}

proc STnot { a } { 
    return "{stnot $a}"
}

proc FLsat { a } {
    return [list 0 $a ]
}

proc FLvld { a } {
    return [list 1 $a ]
}

proc FLisat { a } {
    return [list 2 $a ]
}

proc FLivld { a } {
    return [list 3 $a ]
}

proc FLenf { a } {
    return [list 4 $a ]
}

proc FLinf { a } {
    return [list 5 $a ]
}

proc PLsat { a } {
    return [list 6 $a ]
}

proc PLvld { a } {
    return [list 7 $a ]
}

proc PLenf { a } {
    return [list 8 $a ]
}

proc PLinf { a } {
    return [list 9 $a ]
}

proc TRnot { a } {
    return "{trnot $a}"
}

proc TRnext { a } {
    return "{trnext $a}"
}

proc TRprev { a } {
    return "{trprev $a}"
}

proc TRor { a b } {
    return "{tror $a $b}"
}

proc TRand { a b } {
    return "{trand $a $b}"
}

proc TRequiv { a b } {
    return "{trequiv $a $b}"
}

proc TRimp { a b } {
    return "{trimp $a $b}"
}

proc FEtest { a } {
    return "{fetest $a}"
}

proc FEor { a b } {
    return "{feor $a $b}"
}

proc FEiand { a b } {
    return "{feiand $a $b}"
}

proc FEandi { a b } {
    return "{feandi $a $b}"
}

proc FEfand { a b } {
    return "{fefand $a $b}"
}

proc FEandf { a b } {
    return "{feandf $a $b}"
}

proc FEinit { a } {
    return "{feinit $a}"
}

proc FEpinit { a } {
    return "{fepinit $a}"
}

proc FEfin { a } {
    return "{fefin $a}"
}

proc FEpfin { a } {
    return "{fepfin $a}"
}

proc FEstep { a } {
    return "{festep $a}"
}

proc FEpstep { a } {
    return "{fepstep $a}"
}

proc FEchop { a b } {
    return "{fechop $a $b}"
}

proc FEchopstar { a } {
    return "{fechopstar $a}"
}

proc FEpchopstar { a } {
    return "{fepchopstar $a}"
}

proc FLnot { a } {
    return "{flnot $a}"
}

proc FLnext { a } {
    return "{flnext $a}"
}

proc FLprev { a } {
    return "{flprev $a}"
}

proc FLuntil { a b } {
    return "{fluntil $a $b}"
}

proc FLsince { a b } {
    return "{flsince $a $b}"
}

proc FLor { a b } {
    return "{flor $a $b}"
}

proc FLand { a b } {
    return "{fland $a $b}"
}

proc FLequiv { a b } {
    return "{flequiv $a $b}"
}

proc FLimp { a b } {
    return "{flimp $a $b}"
}

proc FLchop { a b } {
    return "{flchop $a $b}"
}

#proc FLsfin { a } {
#    return "{flsfin $a}"
#}

proc FLpchop { a b } {
    return "{flpchop $a $b}"
}

proc PLfin { a } {
    return "{plfin $a}"
}

proc PLnot { a } {
    return "{plnot $a}"
}

proc PLprev { a } {
    return "{plprev $a}"
}

proc PLnext { a } {
    return "{plnext $a}"
}

proc PLor { a b } {
    return "{plor $a $b}"
}

proc PLand { a b } {
    return "{pland $a $b}"
}

proc PLequiv { a b } {
    return "{plequiv $a $b}"
}

proc PLimp { a b } {
    return "{plimp $a $b}"
}

proc PLsince { a b } {
    return "{plsince $a $b}"
}

proc PLuntil { a b } {
    return "{pluntil $a $b}"
}

proc PLchop { a b } {
    return "{plchop $a $b}"
}

proc PLpchop { a b } {
    return "{plpchop $a $b}"
}
