# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2009-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# $Id: fusion_logic.tac,v 1.5 2010/01/19 11:10:11 acau Exp $

# taccle Declarations
%token ID NEWLINE TRUE FALSE CLB CRB TLB TRB SAT ISAT PSAT VLD IVLD PVLD ENF PENF INF PINF
%token UNTIL
%token SINCE
%token OR
%token AND
%token EQUIV
%token IMP
%token FEIAND
%token FEFAND
%token FEANDI
%token FEANDF
%token FECHOP
%token CHOPSTAR
%token PCHOPSTAR
%token FIN
%token PFIN
%token INIT
%token PINIT
%token TEST
%token STEP
%token PSTEP
%token NEXT
%token PREV
%token NOT

%left UNTIL
%left SINCE
%left OR
%left AND
%left EQUIV
%left IMP
%left UUNTIL
%left USINCE
%left USTOR
%left USTAND
%left UTROR
%left UTRAND
%left UFEOR
%left UFEIAND
%left UFEFAND
%left UFEANDI
%left UFEANDF
%left UCHOP
%left UPCHOP
%left FECHOP
%left UFIN
%left UPFIN
%left UINIT
%left UPINIT
%left UCHOPSTAR
%left UPCHOPSTAR
%left UTEST
%left USTEP
%left UPSTEP
%left UNEXT
%left UPREV
%left UNOT


# Grammar follows
%%
start: line NEWLINE start
 | line
;

line: cfl    { return $1 }
 | error     { return "error" }
 | # empty
;

cfl:  SAT fl                         { set _ [FLsat $2]  }
    | VLD fl                         { set _ [FLvld $2]  }
    | ISAT fl                        { set _ [FLisat $2] }
    | IVLD fl                        { set _ [FLivld $2] }
    | ENF fl                         { set _ [FLenf $2]  }
    | INF fl                         { set _ [FLinf $2]  }
    | PSAT fl                        { set _ [FLsat $2]  }
    | PVLD fl                        { set _ [FLvld $2]  }
    | PENF fl                        { set _ [FLenf $2]  }
    | PINF fl                        { set _ [FLinf $2]  }
;

fl:   ID                             { set _ $1              }
    | TRUE                           { set _ $1              }
    | FALSE                          { set _ $1              }
    | TLB fe TRB fl %prec UCHOP      { set _ [FLchop $2 $4]  }
    | fl TLB pfe TRB %prec UPCHOP    { set _ [FLpchop $1 $3] }
    | fl OR fl                       { set _ [FLor $1 $3]    }
    | fl AND fl                      { set _ [FLand $1 $3]   }
    | fl EQUIV fl                    { set _ [FLequiv $1 $3] }
    | fl IMP fl                      { set _ [FLimp $1 $3]   }
    | NEXT fl                        { set _ [FLnext $2]     }
    | PREV fl                        { set _ [FLprev $2]     }
    | fl UNTIL fl  %prec UUNTIL      { set _ [FLuntil $1 $3] }
    | fl SINCE fl  %prec USINCE      { set _ [FLsince $1 $3] }
    | CLB fl CRB                     { set _ $2              }
    | NOT fl %prec UNOT              { set _ [FLnot $2]      }
;


fe:   CHOPSTAR fe %prec UCHOPSTAR  { set _ [FEchopstar $2]  }
    | STEP tr  %prec USTEP         { set _ [FEstep $2 ]     }
    | TEST st  %prec UTEST         { set _ [FEtest $2]      }
    | INIT st  %prec UINIT         { set _ [FEinit $2]      }
    | FIN  st  %prec UFIN          { set _ [FEfin  $2]      }
    | fe OR fe %prec UFEOR         { set _ [FEor $1 $3]     }
    | st FEIAND fe %prec UFEIAND   { set _ [FEiand $1 $3]   }
    | fe FEIAND st %prec UFEIAND   { set _ [FEiand $3 $1]   }
    | st FEFAND fe %prec UFEFAND   { set _ [FEfand $1 $3]   }
    | fe FEFAND st %prec UFEFAND   { set _ [FEfand $3 $1]   }
    | fe FECHOP fe                 { set _ [FEchop $1 $3 ]  }
    | CLB fe CRB                   { set _ $2               } 
;

pfe:  PCHOPSTAR pfe %prec UPCHOPSTAR { set _ [FEpchopstar $2] }
    | PSTEP ptr  %prec UPSTEP        { set _ [FEpstep $2]     }
    | TEST st  %prec UTEST           { set _ [FEtest $2]      }
    | PINIT st  %prec UPINIT         { set _ [FEpinit $2]     }
    | PFIN  st  %prec UPFIN          { set _ [FEpfin  $2]     }
    | pfe OR pfe %prec UFEOR         { set _ [FEor $1 $3]     }
    | st FEANDI pfe %prec UFEANDI    { set _ [FEandi $3 $1]   }
    | pfe FEANDI st %prec UFEANDI    { set _ [FEandi $1 $3]   }
    | st FEANDF pfe %prec UFEANDF    { set _ [FEandf $3 $1]   }
    | pfe FEANDF st %prec UFEANDF    { set _ [FEandf $1 $3]   }
    | pfe FECHOP pfe                 { set _ [FEchop $1 $3 ]  }
    | CLB pfe CRB                    { set _ $2               } 
;


tr:   ID                      { set _ $1             }
    | TRUE                    { set _ $1             }  
    | FALSE                   { set _ $1             }
    | tr OR tr  %prec UTROR   { set _ [TRor $1 $3]   }
    | tr AND tr %prec UTRAND  { set _ [TRand $1 $3]  }
    | tr EQUIV tr             { set _ [TRequiv $1 $3]}
    | tr IMP tr               { set _ [TRimp $1 $3]  }
    | CLB tr CRB              { set _ $2             }
    | NEXT st %prec UNEXT     { set _ [TRnext $2]    }   
    | NOT tr  %prec UNOT      { set _ [TRnot $2]     }
;

ptr:  ID                        { set _ $1             }
    | TRUE                      { set _ $1             }  
    | FALSE                     { set _ $1             }
    | ptr OR ptr  %prec UTROR   { set _ [TRor $1 $3]   }
    | ptr AND ptr %prec UTRAND  { set _ [TRand $1 $3]  }
    | ptr EQUIV ptr             { set _ [TRequiv $1 $3]}
    | ptr IMP ptr               { set _ [TRimp $1 $3]  }
    | CLB ptr CRB               { set _ $2             }
    | PREV st %prec UPREV       { set _ [TRprev $2]    }   
    | NOT ptr  %prec UNOT       { set _ [TRnot $2]     }
;

st:   ID                       { set _ $1             }
     | TRUE                    { set _ $1             }
     | FALSE                   { set _ $1             }
     | st OR st %prec USTOR    { set _ [STor $1 $3]   }
     | st AND st %prec USTAND  { set _ [STand $1 $3]  }
     | st EQUIV st             { set _ [STequiv $1 $3]}
     | st IMP st               { set _ [STimp $1 $3]  }
     | CLB st CRB              { set _ $2             }
     | NOT st %prec UNOT       { set _ [STnot $2]     }
;

%%

if {![info exist ::starkit::topdir]} {
 source fusion_logic_commands.tcl
 source scanner_fusion_logic.tcl
} else {
 source $::starkit::topdir/fusion_logic_commands.tcl
 source $::starkit::topdir/scanner_fusion_logic.tcl
}


