# flcheck --
#
# This file implements package flcheck, a fusion logic modelchecker 
# using the CUDD and BuDDy BDD packages
#
# Copyright (C) 2013-2025  Antonio Cau, Ben Moszkowski and Helge Janicke

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Example of a strong policy rule
# same example is coded in DCVALID as
#
# discrete;
#
# var A, B, C ; 
#
# define policy as
# (! ( true^<A>^(slen=1)^<B>^(<!C>))) &&
# (! ( (! ( true^<A>^(slen=1)^<B> ))^ <C>));
# 
# infer policy.  
#
# And in PITL2MONA as 
#
# [i] ( !      (true; A? ; len(1) ; B?   ; (!C)? )), 
# [i] ( ! ( (! (true; A? ; len(1) ; B?)) ; C?    ))
# 

###
::bdd_tcl::load_file policy_library.tcl
proc test_policy {} {
    set p "true < test(A) ; pstep(true) ; test(B) >"
    set w "C"
    set p1 "(not ( $p ))"
    set w1 "(not C)"
    return "[l_always_followed_by $p $w] and [l_always_followed_by $p1 $w1]"
}
