%module cudd_tcl
%{
#include "cudd-3.0.0/config.h"  
#include "cudd-3.0.0/mtr/mtr.h"  
#include "cudd-3.0.0/cudd/cudd.h"
#include "cuddDot.h"
#include <stdbool.h>  
%}
%include "cudd-3.0.0/config.h"
%include "cudd-3.0.0/mtr/mtr.h" 
%include "cudd-3.0.0/cudd/cudd.h"
%include "cuddDot.h"
%inline %{
void Cudd_PrintInfoStd(DdManager * dd) {
  Cudd_PrintInfo(dd,stdout);
}
void Cudd_DumpDotty(DdManager * dd, int  n, DdNode ** f, char ** inames, char ** onames) { 
  FILE *dotfile;
  dotfile=fopen("./dotty.dot","w+");
  Cudd_DumpDotnew(dd,n,f,inames,onames,dotfile);
  fclose(dotfile);
}
char **new_name_array(int size) {
  if ( size == 0) return NULL;
  return (char **) malloc(size*sizeof(char *));
}
int *new_int_array(int size) {
  return (int *) malloc(size*sizeof(int));
}
DdNode **new_node_array(int size) {
  return (DdNode **) malloc(size*sizeof(DdNode *));
}
void delete_node_array(DdNode **a) {
  free(a);
}
void delete_name_array(char **a) {
  free(a);
}
void delete_int_array(int *a) {
  free(a);
}
DdNode *array_get_node(DdNode **a, int index) {
  return a[index];
}
int array_get_int(int *a, int index) {
  return a[index];
}
char *array_get_name(char **a, int index) {
  return a[index];
}   
void array_set_node(DdNode **a, int index, DdNode *val) {
  a[index] = val;
}
void array_set_int(int *a, int index, int val) {
  a[index] = val;
}
void array_set_name(char **a, int index, char *val) {
  a[index] = val;
}

%}

#undef Cudd_Not
extern DdNode *Cudd_Not(DdNode *node);

#undef Cudd_IsConstant
extern int Cudd_IsConstant(DdNode *node);

#undef Cudd_NotCond
extern DdNode *Cudd_NotCond(DdNode *node, _Bool c);

#undef Cudd_Regular
extern DdNode *Cudd_Regular(DdNode *node);

#undef Cudd_Complement
extern DdNode *Cudd_Complement(DdNode *node);

#undef Cudd_IsComplement
extern int Cudd_IsComplement(DdNode *node);

#undef Cudd_T
extern DdNode *Cudd_T(DdNode *node);

#undef Cudd_E
extern DdNode *Cudd_E(DdNode *node);

#undef Cudd_V
extern CUDD_VALUE_TYPE Cudd_V(DdNode *node);

#undef Cudd_ReadIndex
extern int Cudd_ReadIndex(DdManager *dd, int index);

#undef Cudd_ForeachCube
extern void Cudd_ForeachCube(DdManager *manager, DdNode *f, DdGen *gen, int *cube, CUDD_VALUE_TYPE value);

#undef Cudd_ForeachPrime
extern void Cudd_ForeachPrime(DdManager *manager, DdNode *l, DdNode *u, DdGen *gen, int *cube);

#undef Cudd_ForeachNode
extern void Cudd_ForeachNode(DdManager *manager, DdNode *f, DdGen *gen, DdNode *node);

#undef Cudd_zddForeachPath
extern void Cudd_zddForeachPath(DdManager *manager, DdNode *f, DdGen *gen, int *path);



