(*  title     : A Shallow encoding of ITL in Isabelle/HOL
    Authors   : Antonio Cau     <cau.researcher at gmail.com>
                Ben Moszkowski
                David Smallwood <drs at dmu.ac.uk>
    Maintainer: Antonio Cau     <cau.researcher at gmail.com>        
    License   : BSD
*)
section \<open>Monitor Example\<close>

theory MonitorExample
imports
   FOTheorems Monitor
begin


(*declare [[show_types]]*)

locale Test =
 fixes v :: "state \<Rightarrow> nat"
 fixes y :: "state \<Rightarrow> bool" 
 fixes z :: "state \<Rightarrow> nat"
 fixes F2 :: "nat statefun \<Rightarrow> temporal "
 fixes F3 :: "bool statefun \<Rightarrow> temporal " 
 fixes F4 :: "nat statefun \<Rightarrow> temporal" 
 fixes F5 :: "nat statefun \<Rightarrow> temporal" 
 fixes Init2 :: "nat statefun \<Rightarrow> temporal "
 fixes Init3 :: "bool statefun \<Rightarrow> temporal " 
 fixes Mon1  :: "state  monitor"
 fixes Mon2  :: "state monitor" 
 fixes Mon3  :: "state monitor" 
 fixes Mon4  :: "state monitor" 
 fixes Mon5  :: "state monitor"
 fixes Mon6  :: "state monitor" 
 defines "F2 \<equiv> (\<lambda> v. TEMP \<box> ( #0 \<le> $v )) "
 defines "F3 \<equiv> (\<lambda> p. TEMP \<box> ( $p \<or> \<not> $p))" 
 defines "F4 \<equiv> (\<lambda> z. TEMP $z=#0 \<and> z gets $z+#1)"  
 defines "F5 \<equiv> (\<lambda> z. TEMP fin($z=#4))" 
 defines "Init2 \<equiv> (\<lambda> v. TEMP $v = #0)"
 defines "Init3 \<equiv> (\<lambda> p. TEMP $p)"
 defines "Mon1 \<equiv> FIRST( F2 v )" 
 defines "Mon2 \<equiv> EMPTY UPTO Mon1" 
 defines "Mon3 \<equiv> Mon1 WITH (F2 v)" 
 defines "Mon4 \<equiv> Mon2 THEN Mon1" 
 defines "Mon5 \<equiv> Mon3 THRU Mon4" 
 defines "Mon6 \<equiv> (FIRST F4 z) WITH (F5 z)" 

lemma (in Test) test:
 " \<turnstile> \<M>(Mon1) =  empty"
proof -
 have 1: "\<turnstile> \<M>(Mon1) = \<rhd>(\<box> ( #0 \<le> $v ))" 
      using F2_def Mon1_def by fastforce
 have 2: "\<turnstile> \<box> ( #0 \<le> $v )"
      by (simp add: Valid_def itl_defs)
 have 3: "\<turnstile> \<rhd>(\<box> ( #0 \<le> $v )) = empty" 
      using "2" by (metis FstTrue int_eq int_eq_true)
 from 1 2 3 show ?thesis by fastforce
qed

lemma (in Test) test1:
 "\<turnstile> \<M>(Mon2) = empty"
proof -
 have 1: "\<turnstile> \<M>(Mon2) = \<M>(EMPTY UPTO Mon1) "  
      using Mon2_def by fastforce
 have 2: "\<turnstile> \<M>(EMPTY UPTO Mon1) = \<rhd>(\<M>(EMPTY) \<or> \<M>(Mon1))" 
      by fastforce
 have 3: "\<turnstile> \<rhd>(\<M>(EMPTY) \<or> \<M>(Mon1)) = \<rhd>(empty \<or> empty)" 
      using test by (metis "2" MEmptyAlt int_eq)  
 have 4: "\<turnstile> \<rhd>(empty \<or> empty) = empty" 
      using FstEmptyOrEqvEmpty by blast
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma (in Test) test2:
 "\<turnstile> \<M>(Mon3) = empty"
proof - 
 have 1: "\<turnstile> \<M>(Mon3) = \<M>(Mon1 WITH (F2 v))" using Mon3_def by fastforce
 have 2: "\<turnstile> \<M>(Mon1 WITH (F2 v)) = (\<M>(Mon1) \<and> (F2 v))" by fastforce
 have 3: "\<turnstile> (\<M>(Mon1) \<and> (F2 v)) = (empty \<and> (F2 v)) " using test by fastforce
 have 4: "\<turnstile> (F2 v)" by (simp add: F2_def Valid_def itl_defs)
 have 5: "\<turnstile> (empty \<and> (F2 v)) = empty" using "4" by fastforce
 from 1 2 3 5 show ?thesis by fastforce
qed

lemma (in Test) test3:
 "\<turnstile> \<M>(Mon4) = empty"
proof -
 have 1: "\<turnstile> \<M>(Mon4) = \<M>(Mon2 THEN Mon1)" 
      using Mon4_def by fastforce
 have 2: "\<turnstile> \<M>(Mon2 THEN Mon1) = ( \<M>(Mon2) ) \<frown>( \<M>(Mon1) )" 
      by fastforce
 have 3: "\<turnstile> ( \<M>(Mon2) ) \<frown>( \<M>(Mon1) ) = empty\<frown>empty" 
      using test test1 using SChopEqvSChop by blast
 have 4: "\<turnstile> empty\<frown> empty = empty" 
     by (simp add: EmptySChop)
 from 1 2 3 4 show ?thesis by fastforce
qed

lemma (in Test) test4:
 "\<turnstile> \<M>(Mon5) = empty"
proof -
 have 1: "\<turnstile> \<M>(Mon5) = \<M>(Mon3 THRU Mon4)" 
      using Mon5_def by fastforce
 have 2: "\<turnstile> \<M>(Mon3 THRU Mon4) = \<rhd>(di(\<M>(Mon3)) \<and> di(\<M>(Mon4)))" 
      by fastforce
 have 3: "\<turnstile> (di(\<M>(Mon3)) \<and> di(\<M>(Mon4))) = (di(empty) \<and> di(empty))" 
      using test3 test2 by (metis inteq_reflection lift_and_com) 
 hence 4: "\<turnstile> \<rhd>(di(\<M>(Mon3)) \<and> di(\<M>(Mon4))) = \<rhd>(di(empty) \<and> di(empty))" 
      by (simp add: FstEqvRule)
 have 5: "\<turnstile> \<rhd>(di(empty) \<and> di(empty)) = \<rhd>(di(empty))" 
      by simp
 have 6: "\<turnstile> \<rhd>(di(empty)) = empty"
      using FstDiEqvFst FstEmpty by fastforce
 from 6 5 4 2 1 show ?thesis by fastforce
qed

lemma (in Test) test5:
 "\<turnstile> \<M> (Mon6) = (\<rhd>($z=#0  \<and> z gets $z+#1) \<and> fin($z=#4) ) "
proof -
 have 1: "\<turnstile> \<M>(Mon6) = (\<M>(FIRST F4 z) \<and> (F5 z))"
      using Mon6_def by fastforce
 have 2: "\<turnstile> (\<M>(FIRST F4 z) \<and> (F5 z)) = (\<rhd>(F4 z) \<and> fin($z=#4)) "
      using F5_def by fastforce
 have 3: "\<turnstile> (\<rhd>(F4 z) \<and> fin($z=#4)) = (\<rhd>($z=#0 \<and>  z gets $z+#1) \<and> fin($z=#4) )"
      using F4_def by fastforce
 from 1 2 3 show ?thesis by fastforce
qed

lemma (in Test) test5_1:
 "\<turnstile> \<rhd>($z=#0 \<and>  z gets $z+#1) \<and> fin($z=#4)  \<longrightarrow>
    \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) 
 "
using FstWithAndImp by blast

lemma (in Test) test5_2:
 "(s \<Turnstile> ($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4) \<and> finite) =
  (nfinite s \<and>z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4)"
apply (simp add: itl_defs nsubn_def1)
by (metis ndropn_nfirst nfirst_eq_nnth_zero ntaken_nfirst)


lemma (in Test) test5_3:
 " (nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4)
  \<Longrightarrow>
 (nfinite s \<and> z (nnth s 0) = 0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4)
  " 
proof -
  assume a0: "nfinite s \<and> (z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4)"
  show "nfinite s \<and> (z (nnth s 0) =0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4)  "
  proof -
    have 0: "nfinite s" using a0 by auto
    have 1: "z (nnth s 0) =0 " using "a0" by auto
    have 2: "z (nnth s (the_enat (nlength s))) = 4" using "a0" by auto
    have 3: "(\<forall> i\<le> nlength s. z (nnth s i) = i)" 
    proof 
      fix i
      show "i \<le> nlength s \<longrightarrow> z ( nnth s i) = i"
      proof
       (induct i)
       case 0
       then show ?case by (simp add: "1")
       next
       case (Suc i)
       then show ?case by (simp add: Suc_ile_eq a0)
       qed
    qed
    from 0 1 2 3 show ?thesis by auto
   qed  
qed 

lemma (in Test) test5_4:
  " (nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4) \<Longrightarrow>
    (nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4)
  "
proof -
 assume a0: "(nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4) "
 show "(nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4) "
 proof -
  have 0: "nfinite s" using a0 by auto
  have 1: "z (nnth s 0) =0 " using a0 by auto
  have 2: "z (nnth s (the_enat (nlength s))) = 4" using a0 by auto
  have 3: "(\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i)))" by (simp add: Suc_ile_eq a0)
  from 0 1 2 3 show ?thesis by auto
 qed
qed

lemma (in Test) test5_5:
 " (nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i< nlength s. z (nnth s (Suc i)) = Suc(z (nnth s i))) \<and> 
   z (nnth s (the_enat (nlength s))) = 4)
  =
 (nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4)
  " 
using   test5_3 test5_4 by blast  

lemma (in Test) test5_6 :
 "(nfinite s \<and> z (nnth s 0) =0  \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i)
  \<and> z (nnth s (the_enat (nlength s))) = 4) =
 (nlength s =4 \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i) )
 "
by (metis dual_order.refl nfinite_conv_nlength_enat numeral_eq_enat the_enat.simps zero_enat_def zero_le_numeral)

lemma (in Test) test5_7 :
 "(s \<Turnstile> ( $z=#0 \<and> z gets $z+#1) \<and> fin($z=#4) \<and> finite) =
  (nlength s =4 \<and> (\<forall> i\<le> nlength s. z (nnth s i) = i) )"
using test5_6[of s] test5_5[of s] test5_2[of s]   by presburger

(*
(
   ( (s \<Turnstile> ($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> nlength s =0) \<or>
   ( 0 < nlength s  \<and> (s \<Turnstile> $z=#0 \<and> z gets $z+#1 \<and> fin($z=#4)) \<and>
     (\<forall> ia < nlength s. (prefix ia s \<Turnstile> \<not>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)))))
  ) 
*)

lemma (in Test) test5_8_0: 
 "(s \<Turnstile> \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4))) =
  (s \<Turnstile> \<rhd>((($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite ) ) " 
using FstEqvFstAndFinite[of "TEMP ($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)"]
unfolding Valid_def by auto

lemma (in Test) test5_8_1: 
 "(\<turnstile> \<rhd>((($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite ) ) =
  (\<turnstile> \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4) \<and> finite ) ) " 
proof -
 have 1: "\<turnstile> ((($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite ) =
            (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4) \<and> finite )"
      by auto
 show ?thesis by (metis "1" int_eq)
qed

lemma (in Test) test5_8_2: 
 "(s \<Turnstile> \<rhd>((($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite ) ) =
  (s \<Turnstile> \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4) \<and> finite ) ) " 
using test5_8_1 unfolding Valid_def 
by (simp add: Fstsem)




lemma (in Test) test5_8 :
 "(s \<Turnstile> \<rhd>( (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite)) =
((s \<Turnstile> (($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite) \<and> nlength s = 0 \<or>
   0 < nlength s \<and>
   nfinite s \<and>
   (s \<Turnstile> (($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite) \<and>
   (\<forall>ia. enat ia < nlength s \<longrightarrow> (ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite))))
" 
using Fstsem[of "TEMP (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite" s]  
by simp

lemma (in Test) test5_9 :
 "\<not>( (s \<Turnstile> (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite) \<and> nlength s =0) "
using test5_7  
by (metis (mono_tags, lifting)  unl_lift2 zero_neq_numeral)

lemma (in Test) test5_10:
 "  (s \<Turnstile> (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite) 
   \<Longrightarrow> 
   0 < nlength s \<and>
   nfinite s \<and>
   (s \<Turnstile> (($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite) \<and>
   (\<forall>ia. enat ia < nlength s \<longrightarrow> (ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite)))
 "
proof -
 assume a0: "s \<Turnstile> (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite "
 show "0 < nlength s \<and>
   nfinite s \<and>
   (s \<Turnstile> (($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite) \<and>
   (\<forall>ia. enat ia < nlength s \<longrightarrow> (ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite)))"
 proof -
  have 0: " nfinite s" using a0 by (simp add: finite_defs)
  have 1: "0 < nlength s" using test5_7 a0 gr_zeroI test5_9 by blast
  have 2: "(\<forall>ia. enat ia < nlength s \<longrightarrow> (ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite))) "
  proof
   fix ia
   show "enat ia < nlength s \<longrightarrow>
         (ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite))"
   proof -
   have 1: "(ntaken ia s \<Turnstile> \<not> ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite)) =
            (\<not>(ntaken ia s \<Turnstile>  ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite)))"
             by auto
   have 2: "(ntaken ia s \<Turnstile>  ((($z = #0 \<and> z gets $z + #1) \<and> fin ($z = #4)) \<and> finite)) =
            (nlength (ntaken ia s) = 4 \<and> (\<forall>i. enat i \<le> nlength (ntaken ia s) \<longrightarrow> z (nnth (ntaken ia s) i) = i))  "
             using test5_7[of "ntaken ia s"] by auto
   have 3: "enat ia < nlength s \<longrightarrow>
            \<not>(nlength (ntaken ia s) = 4 \<and> (\<forall>i. enat i \<le> nlength (ntaken ia s) \<longrightarrow> z (nnth (ntaken ia s) i) = i))"
              using a0 using test5_7[of "ntaken ia s"] 
       using not_less_iff_gr_or_eq test5_7 by fastforce 
   from 1 2 3 show ?thesis by blast
   qed
  qed
  from 0 1 2 show ?thesis using a0 by blast
 qed
qed

lemma (in Test) test5_11 :
 " (s \<Turnstile> \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4))) =
   (s \<Turnstile> (($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite)"
by (meson test5_10 test5_8 test5_8_0)
 

lemma (in Test) test5_12 :
 "\<turnstile> \<rhd>(($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) = ((($z=#0 \<and> z gets $z+#1) \<and> fin($z=#4)) \<and> finite) "
using test5_11 by (simp add: Valid_def)


end